import { registerBlockType } from '@wordpress/blocks';
import './style.scss';

/**
 * Internal dependencies
 */
import Edit from './edit';
import save from './save';
import metadata from './block.json';


registerBlockType(metadata.name, {
	/**
	 * @see ./edit.js
	 */
	edit: Edit,

	/**
	 * Block icon
	 */
	icon: {
		src: <svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="28" height="32" viewBox="0 0 28 32"> <title>image-box</title> <path stroke="#000" fill="#000" d="M23.058 31.258h-18.342c-1.090-0.001-2.135-0.435-2.906-1.206s-1.205-1.816-1.206-2.906v-11.962c0-0.099 0.039-0.194 0.11-0.264s0.165-0.109 0.264-0.109c0.099 0 0.194 0.039 0.264 0.109s0.109 0.165 0.109 0.264v11.962c0.001 0.892 0.356 1.747 0.987 2.378s1.486 0.985 2.378 0.986h18.342c0.892-0.001 1.747-0.356 2.378-0.986s0.986-1.486 0.987-2.378v-22.43c-0.001-0.892-0.356-1.747-0.986-2.378s-1.486-0.986-2.378-0.986h-18.342c-0.892 0.001-1.747 0.356-2.378 0.987s-0.986 1.486-0.987 2.378v4.275c0 0.099-0.039 0.194-0.109 0.264s-0.165 0.11-0.264 0.11-0.194-0.039-0.264-0.11c-0.070-0.070-0.11-0.165-0.11-0.264v-4.275c0.001-1.090 0.435-2.135 1.206-2.906s1.816-1.205 2.906-1.206h18.342c1.090 0.001 2.135 0.435 2.906 1.206s1.205 1.816 1.206 2.906v22.43c-0.001 1.090-0.435 2.135-1.206 2.906s-1.816 1.205-2.906 1.206z"></path> <path stroke="#000" fill="#000" d="M14.064 26.675h-6.144c-0.099 0-0.194-0.039-0.264-0.11s-0.11-0.165-0.11-0.264 0.039-0.194 0.11-0.264c0.070-0.070 0.165-0.109 0.264-0.109h6.144c0.099 0 0.194 0.039 0.264 0.109s0.11 0.165 0.11 0.264c0 0.099-0.039 0.194-0.11 0.264s-0.165 0.11-0.264 0.11z"></path> <path stroke="#000" fill="#000" d="M19.852 26.675h-3.079c-0.099 0-0.194-0.039-0.264-0.11s-0.11-0.165-0.11-0.264 0.039-0.194 0.11-0.264c0.070-0.070 0.165-0.109 0.264-0.109h3.079c0.099 0 0.194 0.039 0.264 0.109s0.109 0.165 0.109 0.264c0 0.099-0.039 0.194-0.109 0.264s-0.165 0.11-0.264 0.11z"></path> <path stroke="#000" fill="#000" d="M21.346 22.52h-14.92c-0.892-0.001-1.747-0.356-2.378-0.986s-0.986-1.486-0.986-2.378v-12.73c0.001-0.892 0.356-1.747 0.987-2.378s1.486-0.986 2.378-0.987h8.404c0.099 0 0.194 0.039 0.264 0.11s0.109 0.165 0.109 0.264-0.039 0.194-0.109 0.264c-0.070 0.070-0.165 0.11-0.264 0.11h-8.404c-0.694 0.001-1.359 0.277-1.849 0.767s-0.766 1.156-0.767 1.85v12.73c0.001 0.694 0.277 1.359 0.767 1.85s1.156 0.766 1.849 0.767h14.92c0.694-0.001 1.359-0.277 1.85-0.767s0.766-1.156 0.767-1.85v-12.73c-0.001-0.694-0.277-1.359-0.767-1.849s-1.156-0.766-1.849-0.767h-2.531c-0.099 0-0.194-0.039-0.264-0.11s-0.109-0.165-0.109-0.264 0.039-0.194 0.109-0.264c0.070-0.070 0.165-0.11 0.264-0.11h2.531c0.892 0.001 1.747 0.356 2.378 0.986s0.986 1.486 0.986 2.378v12.73c-0.001 0.892-0.356 1.747-0.986 2.378s-1.486 0.986-2.378 0.986z"></path> <path stroke="#000" fill="#000" d="M8.719 20.277c-0.075 0-0.148-0.022-0.21-0.064s-0.11-0.101-0.138-0.17c-0.028-0.069-0.035-0.145-0.019-0.218s0.053-0.14 0.107-0.191l5.22-5.015 2.696 2.265 3.692-4.567 2.305 2.522c0.033 0.036 0.059 0.079 0.075 0.125s0.024 0.095 0.022 0.144-0.014 0.097-0.035 0.142c-0.021 0.044-0.050 0.084-0.086 0.117s-0.079 0.059-0.125 0.075c-0.046 0.017-0.095 0.024-0.144 0.022s-0.097-0.014-0.142-0.035-0.084-0.050-0.117-0.086l-1.718-1.88-3.625 4.484-2.762-2.323-4.735 4.549c-0.070 0.067-0.164 0.105-0.261 0.104z"></path> <path stroke="#000" fill="#000" d="M11.996 13.721c-0.35 0-0.692-0.104-0.983-0.298s-0.518-0.471-0.652-0.794c-0.134-0.323-0.169-0.679-0.101-1.022s0.237-0.658 0.484-0.906c0.247-0.247 0.562-0.416 0.906-0.484s0.699-0.033 1.022 0.1 0.6 0.36 0.794 0.651c0.194 0.291 0.298 0.633 0.298 0.983-0 0.469-0.187 0.919-0.518 1.251s-0.781 0.518-1.251 0.519zM11.996 10.93c-0.202 0-0.4 0.060-0.567 0.172s-0.299 0.272-0.376 0.458c-0.077 0.187-0.097 0.392-0.058 0.59s0.137 0.38 0.28 0.523c0.143 0.143 0.325 0.24 0.523 0.279s0.403 0.019 0.59-0.058c0.187-0.077 0.346-0.208 0.458-0.376s0.172-0.366 0.172-0.568c-0-0.271-0.108-0.53-0.299-0.722s-0.451-0.299-0.722-0.299z"></path> </svg>,
	},

	/**
	 * @see ./save.js
	 */
	save,
});
